/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.views;

import com.aptana.core.util.ArrayUtil;
import com.aptana.samples.ISamplesManager;
import com.aptana.samples.SamplesPlugin;
import com.aptana.samples.model.IProjectSample;
import com.aptana.samples.model.SampleCategory;
import com.aptana.samples.model.SamplesReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SamplesViewContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ISamplesManager) {
            ISamplesManager manager = (ISamplesManager)parentElement;
            List categories = manager.getCategories();
            ArrayList<SampleCategory> result = new ArrayList<SampleCategory>();
            for (SampleCategory category : categories) {
                List samples = manager.getSamplesForCategory(category.getId());
                if (samples == null || samples.size() <= 0) continue;
                result.add(category);
            }
            return result.toArray(new SampleCategory[result.size()]);
        }
        if (parentElement instanceof SampleCategory) {
            List samplesRefs = SamplesPlugin.getDefault().getSamplesManager().getSamplesForCategory(((SampleCategory)parentElement).getId());
            ArrayList<IProjectSample> children = new ArrayList<IProjectSample>();
            for (IProjectSample ref : samplesRefs) {
                children.add(ref);
            }
            return children.toArray(new Object[children.size()]);
        }
        return ArrayUtil.NO_STRINGS;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof SamplesReference) {
            return ((SamplesReference)element).getCategory();
        }
        if (element instanceof SampleCategory) {
            return SamplesPlugin.getDefault().getSamplesManager();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

